/******************************************************/
/* Examples Program For "ET-BASE dsPIC30F2010"  Board */
/* Hardware    : ET-BASE dsPIC30F2010                 */
/* Target MCU  : dsPIC30F2010                         */
/*       	   : X-TAL : 7.3728 MHz                   */
/*             : Run 117.9648MHz                      */
/*             : Selec OSC Mode = XT w/PLL 16x        */
/* Compiler    : MPLAB v8.40 + C30 v3.20B      	      */
/* Last Update : 12/October/2009                      */
/******************************************************/
/* Function    : Example Use RB0 on Output Mode       */
/*             : LED Blink on RB0                     */	
/******************************************************/

#include <p30f2010.h>                                		// dsPIC30F2010 MPU Register

/* Setup Configuration For ET-BASE dsPIC30F2010 */
_FOSC(CSW_FSCM_OFF & XT_PLL16);								// Disable Clock Switching,Enable Fail-Salf Clock
                                                        	// Clock Source = Primary XT + (PLL x 16)
_FWDT(WDT_OFF);												// Disable Watchdog 
_FBORPOR(PBOR_OFF & PWRT_64 & MCLR_EN);						// Disable Brown-Out ,Power ON = 64mS,Enable MCLR
_FGS(CODE_PROT_OFF);										// Code Protect OFF
/* End Configuration For ET-BASE dsPIC30F2010 */

/* pototype  section */
void delay(unsigned long int);								// Delay Time Function

int main(void)
{  
  TRISBbits.TRISB0 = 0;										// Config RB0 = Output
  
  // Loop Blink LED on RB0 //
  while(1)													// Loop Continue
  {
    LATBbits.LATB0 = !LATBbits.LATB0; 						// Toggle Output RB0 (1 = ON LED, 0 = OFF LED)
	delay(100000);	   										// Display LED Delay
  }   
}	  

/***********************/
/* Delay Time Function */
/*    1-4294967296     */
/***********************/
void delay(unsigned long int count1)
{
  while(count1 > 0) {count1--;}								// Loop Decrease Counter	
}
